<?php 
require("../fpdf/fpdf.php");
include("../config/dbcon.php");

if (isset($_GET['invoice_no'])) {
    $invoiceNo = $_GET['invoice_no'];

    // Fetch order and customer details
    $orderQuery = "SELECT o.*, c.* FROM tbl_order_penb o JOIN tbl_customers_penb c ON c.id = o.customer_id WHERE o.invoice_no = '$invoiceNo' LIMIT 1";
    $orderQueryRes = mysqli_query($conn, $orderQuery);

    if ($orderQueryRes && mysqli_num_rows($orderQueryRes) > 0) {
        $orderDataRow = mysqli_fetch_assoc($orderQueryRes);

        // Store customer details in variables for easy access
        $customerName = $orderDataRow['fld_customer_name'];
        $customerAddress1 = $orderDataRow['fld_customer_address1'];
        $customerAddress2 = $orderDataRow['fld_customer_address2'];
        $customerCity = $orderDataRow['fld_customer_city'];
        $customerPoscode = $orderDataRow['fld_customer_poscode'];
        $customerState = $orderDataRow['fld_customer_state'];
        $plateNumber = $orderDataRow['plate_number'];
        $deposit = $orderDataRow['deposit'];
        $orderDate = $orderDataRow['order_date']; 
        $salePerson = $orderDataRow['order_place_by_id']; 

        // Fetch items and assign to $products and $laborCharges arrays
        $orderItemQuery = 
            "SELECT 
                  oi.quantity AS orderItemQuantity, oi.price AS orderItemPrice, o.invoice_no, p.id AS product_id, 
                  p.fld_product_name AS product_name, lb.id AS labor_id, lb.charge_desc AS labor_name
              FROM  tbl_order_penb AS o 
              JOIN tbl_order_items AS oi ON oi.order_id = o.id
              LEFT JOIN tbl_products_penb AS p ON p.id = oi.product_id
              LEFT JOIN tbl_labourcharge_penb AS lb ON lb.id = oi.product_id 
              WHERE o.invoice_no = '$invoiceNo'";

        $orderItemRes = mysqli_query($conn, $orderItemQuery);

        if ($orderItemRes && mysqli_num_rows($orderItemRes) > 0) {
            $products = [];
            $laborCharges = [];
            $totalProductAmount = 0;
            $totalLaborChargeAmount = 0;

            while ($orderItemRow = mysqli_fetch_assoc($orderItemRes)) {
                if (!empty($orderItemRow['labor_id'])) {
                    $laborCharges[] = $orderItemRow;
                    $totalLaborChargeAmount += $orderItemRow['orderItemPrice'] * $orderItemRow['orderItemQuantity'];
                } else {
                    $products[] = $orderItemRow;
                    $totalProductAmount += $orderItemRow['orderItemPrice'] * $orderItemRow['orderItemQuantity'];
                }
            }
        } else {
            echo '<h5>No record found</h5>';
        }
    } else {
        echo "Order not found.";
    }
} else {
    echo "Invalid request.";
}

class PDF extends FPDF {

    function Header() {
        $this->AddFont("Montserrat-Regular", "", "Montserrat-Regular.php");
        $this->AddFont("Montserrat-Medium", "", "Montserrat-Medium.php");
        $this->AddFont("Montserrat-Bold", "", "Montserrat-Bold.php");

        $this->Image('../logo.jpeg', 15, 9, 20); 
        $this->SetFont("Montserrat-Regular", "", 9);
        $this->SetY(7);
        $this->SetX(40);
        $this->Cell(50, 7, "KSQ 10 ENTERPRISE", 0, 1);
        $this->SetY(13);
        $this->SetX(40);
        $this->Cell(50, 7, "9632 JARAK ATAS,", 0, 1);
        $this->SetY(19);
        $this->SetX(40);
        $this->Cell(50, 7, "TASEK GELUGOR PNG 13310", 0, 1);
        $this->SetY(25);
        $this->SetX(40);
        $this->Cell(50, 7, "Malaysia", 0, 1);

        $this->SetY(7);
        $this->SetX(-40);
        $this->SetFont("Montserrat-Medium", "", 12);
        $this->Cell(50, 10, "Workshop &", 0, 1);

        $this->SetY(13);
        $this->SetX(-28);
        $this->SetFont("Montserrat-Medium", "", 12);
        $this->Cell(50, 10, "Repair", 0, 1);

        $this->SetDrawColor(169, 169, 169); 
        $this->Line(10, 37, 202, 37);
        $this->SetY(50);
    }

    function CheckPageBreak($h) {
        if ($this->GetY() + $h > $this->PageBreakTrigger) {
            $this->AddPage(); 
            $this->TableHeader(); 
        }
    }

    function TableHeader() {
        $this->SetFont("Montserrat-Medium", "", 10);
        $this->SetX(10);
        $this->Cell(10, 9, "#", 0, 0, 'C'); 
        $this->Cell(90, 9, "Description", 0, 0);
        $this->SetX(120);
        $this->Cell(40, 9, "Unit Price", 0, 0);
        $this->Cell(20, 9, "Quantity", 0, 0);
        $this->Cell(20, 9, "Total", 0, 1, 'R');
        $this->SetDrawColor(169, 169, 169);
        $this->Line(10, $this->GetY() + 7, 202, $this->GetY() + 7); 
    }

    function Body($products, $laborCharges, $customerName, $customerAddress1, $customerAddress2, $customerCity, $customerPoscode, $customerState, $plateNumber, $orderDate, $salePerson, $deposit) {
        $grandTotal = 0;
        $this->SetFont("Montserrat-Regular", "", 11);
        
        $yPos = $this->GetY();
        
        $this->SetY($yPos - 6);
        $this->SetX(10);
        $this->Cell(50, 7, "$customerName - $plateNumber");

        $addressDisplayed = false;

        if (!empty($customerAddress1)) {
            $this->SetY($this->GetY() + 7);
            $this->SetX(10);
            $this->Cell(50, 7, "$customerAddress1");
            $addressDisplayed = true;
        }

        if (!empty($customerAddress2)) {
            $this->SetY($this->GetY() + 7);
            $this->SetX(10);
            $this->Cell(50, 7, "$customerAddress2");
            $addressDisplayed = true;
        }

        if (!empty($customerCity) || !empty($customerPoscode)) {
            $this->SetY($this->GetY() + 7);
            $this->SetX(10);
            $this->Cell(50, 7, "$customerCity $customerPoscode");
            $addressDisplayed = true;
        }

        if (!empty($customerState)) {
            $this->SetY($this->GetY() + 7);
            $this->SetX(10);
            $this->Cell(50, 7, $customerState);
            $addressDisplayed = true;
        }

        if ($addressDisplayed) {
            $this->SetY($this->GetY() + 10); 
        } else {
            $this->SetY($yPos); 
        }

        $this->SetX(-80);
        $this->SetFont("Montserrat-Regular", "", 18);
        $this->Cell(50, 10, "Invoice " . $_GET['invoice_no'], 0, 1);

        $this->SetY($this->GetY() + 2);
        $this->SetX(10); 
        $this->SetFont("Montserrat-Medium", "", 10);
        $this->Cell(30, 10, "Quotation Date:", 0, 0); 

        $this->SetFont("Montserrat-Regular", "", 10);
        $this->Cell(40, 10, "$orderDate", 0, 0); 

        $this->SetX(90); 
        $this->SetFont("Montserrat-Medium", "", 10);
        $this->Cell(30, 10, "Source:", 0, 0); 

        $this->SetX(105);
        $this->SetFont("Montserrat-Regular", "", 10);
        $this->Cell(50, 10, "$salePerson", 0, 1); 

        $productSubtotal = 0;
        $laborSubtotal = 0;

        $this->SetY($this->GetY() + 2); 
        $this->SetDrawColor(169, 169, 169);
        $this->Line(10, $this->GetY() - 2, 202, $this->GetY() - 2);

        $this->SetY($this->GetY() + 2);
        $this->SetX(10);
        $this->SetFont("Montserrat-Medium", "", 10);
        $this->Cell(10, 9, "#", 0, 0, 'C'); 
        $this->Cell(90, 9, "Description", 0, 0);
        $this->SetX(120);
        $this->Cell(40, 9, "Unit Price", 0, 0);
        $this->Cell(20, 9, "Quantity", 0, 0);
        $this->Cell(20, 9, "Total", 0, 1, 'R');

        $this->SetFont("Montserrat-Regular", "", 10);
        $this->SetFillColor(200, 200, 200);
        $this->SetY($this->GetY() + 1); 
        $this->SetX(10);
        $this->SetFont("Montserrat-Medium", "", 12);
        $this->Cell(190, 9, "Item", 0, 1, 'L', true);

        $productNumber = 1; 

        $this->SetFont("Montserrat-Regular", "", 11); 
        foreach ($products as $product) {
            $this->CheckPageBreak(9); 

            $startY = $this->GetY();
            $this->SetX(10);

            $this->Cell(10, 9, $productNumber++, 0, 0, 'C'); 

            $this->MultiCell(100, 9, $product['product_name'], 0, 'L');

            $nameHeight = $this->GetY() - $startY;

            $this->SetY($startY);
            $this->SetX(120); 

            $this->Cell(40, 9, number_format($product['orderItemPrice'], 2), 0, 0);

            $this->Cell(20, 9, $product['orderItemQuantity'], 0, 0);

            $this->Cell(20, 9, number_format($product['orderItemPrice'] * $product['orderItemQuantity'], 2), 0, 1, 'R');
            $productSubtotal += $product['orderItemPrice'] * $product['orderItemQuantity'];

            $this->SetY($startY + max($nameHeight, 9)); 
        }

        $this->SetFont("Montserrat-Medium", "", 11);
        $this->SetY($this->GetY() + 1);
        $this->SetX($this->GetX() + 140);
        $this->Cell(50, 10, "Subtotal: RM " . number_format($productSubtotal, 2), 0, 1, 'R');

        $this->SetFillColor(200, 200, 200);
        $this->SetY($this->GetY() + 2); 
        $this->SetX(10);
        $this->SetFont("Montserrat-Medium", "", 12);
        $this->Cell(190, 9, "Labour Charge", 0, 1, 'L', true);

        $chargeNumber = 1;

        $this->SetFont("Montserrat-Regular", "", 11); 
        foreach ($laborCharges as $laborCharge) {
            $this->CheckPageBreak(9); 

            $startsY = $this->GetY();
            $this->SetX(10);

            $this->Cell(10, 9, $chargeNumber++, 0, 0, 'C');
            $this->MultiCell(90, 9, $laborCharge['labor_name'], 0, 'L');

            $nameHeights = $this->GetY() - $startsY;

            $this->SetY($startsY);
            $this->SetX(120); 

            $this->Cell(40, 9, number_format($laborCharge['orderItemPrice'], 2), 0, 0);

            $this->Cell(20, 9, $laborCharge['orderItemQuantity'], 0, 0);

            $this->Cell(20, 9, number_format($laborCharge['orderItemPrice'] * $laborCharge['orderItemQuantity'], 2), 0, 1, 'R');
            $laborSubtotal += $laborCharge['orderItemPrice'] * $laborCharge['orderItemQuantity'];

            $this->SetY($startsY + max($nameHeights, 9)); 
        }

        $this->SetFont("Montserrat-Medium", "", 11);
        $this->SetY($this->GetY() + 1);
        $this->SetX($this->GetX() + 140);
        $this->Cell(50, 10, "Subtotal: RM " . number_format($laborSubtotal, 2), 0, 1, 'R');

        $this->SetY($this->GetY() + 3); 
        $this->SetDrawColor(169, 169, 169);
        $this->Line(10, $this->GetY() - 2, 202, $this->GetY() - 2);

        $total = $productSubtotal + $laborSubtotal;

        $this->SetFont("Montserrat-Regular", "", 12);
        $this->SetY($this->GetY() + 1);
        $this->SetX($this->GetX() + 20);
        $this->Cell(140, 10, "Total :", 0, 0, 'R');
        $this->Cell(30, 10, "RM " . number_format($total, 2), 0, 1, 'R');

        $this->SetFont("Montserrat-Regular", "", 12);
        $this->SetY($this->GetY() + 1); 
        $this->SetX($this->GetX() + 20);
        $this->Cell(140, 10, "Deposit :", 0, 0, 'R');
        $this->Cell(30, 10, "-RM " . number_format($deposit, 2), 0, 1, 'R');

        $grandTotal = $total - $deposit;

        $this->SetFont("Montserrat-Bold", "", 12);
        $this->SetY($this->GetY() + 1);
        $this->SetX($this->GetX() + 20);
        $this->Cell(140, 10, "Grand Total :", 0, 0, 'R');
        $this->Cell(30, 10, "RM " . number_format($grandTotal, 2), 0, 1, 'R');

        $this->SetFont("Montserrat-Regular", "", 12);
        $this->SetY($this->GetY() + -8);
        $this->SetX($this->GetX() + 4);
        $this->Cell(50, 10, "Payment Communications: " .  $_GET['invoice_no'], 0, 1, 'L');

        $this->SetFont("Montserrat-Regular", "", 12);
        $this->SetY($this->GetY() + -1);
        $this->SetX($this->GetX() + 4);
        $this->Cell(50, 10, "Maybank", 0, 1, 'L');

        $this->SetFont("Montserrat-Regular", "", 12);
        $this->SetY($this->GetY() + -1);
        $this->SetX($this->GetX() + 4);
        $this->Cell(50, 10, "557410562928", 0, 1, 'L');

        $this->SetFont("Montserrat-Regular", "", 12);
        $this->SetY($this->GetY() + -1);
        $this->SetX($this->GetX() + 4);
        $this->Cell(50, 10, "KSQ10 ENTERPRISE", 0, 1, 'L');
    }

    function Footer() {
        $this->SetY(-20); 
        $this->SetFont("Montserrat-Regular", "", 10);
        $pageWidth = $this->GetPageWidth();
        $footerText = "0176996718 ksq10global@gmail.com";
        $textWidth = $this->GetStringWidth($footerText);
        $this->SetX(($pageWidth - $textWidth) / 2);
        $this->Line(10, $this->GetY() - 2, $pageWidth - 10, $this->GetY() - 2);
        $this->Cell($textWidth, 10, $footerText, 0, 1, "C");
        $this->Line(10, $this->GetY() + 2, $pageWidth - 10, $this->GetY() + 2);
        $this->Ln(2);
        $this->Cell(0, 10, 'Page ' . $this->PageNo(), 0, 0, 'C');
    }
}

$pdf = new PDF();
$pdf->AddPage();
$pdf->Body($products, $laborCharges, $customerName, $customerAddress1, $customerAddress2, $customerCity, $customerPoscode, $customerState, $plateNumber, $orderDate, $salePerson, $deposit);
$pdfFilename = 'Invoice_' . $_GET['invoice_no'] . '.pdf';
$pdf->Output('I', $pdfFilename);
?>
