<?php include('includes/header.php'); ?>

<style>
    .small-img-row {
        display: flex;
        align-items: center;
        background: #f8f9fa;
        border: 1px solid #dee2e6;
        border-radius: 6px;
        margin: 10px 0;
        padding: 15px;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    }
    .small-img-left {
        width: 150px; /* Adjust the width as needed */
        margin-right: 20px;
    }
    .small-img-left img {
        width: 100%;
        border-radius: 6px;
    }
    .small-img {
        position: relative;
        display: inline-block;
    }
    .play-btn {
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        color: #eb2f06;
        font-size: 2.5rem; /* Adjust size as needed */
        cursor: pointer;
        transition: color 0.3s;
    }
    .play-btn:hover {
        color: #ff4757;
    }
    .video-player {
        display: flex;
        justify-content: center;
        align-items: center;
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.8);
        z-index: 1050;
        display: none;
    }
    .video-player video {
        max-width: 80%;
        max-height: 80%;
        border-radius: 8px;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
    }
    .close-btn {
        position: absolute;
        top: 10px;
        right: 10px;
        color: #eb2f06;
        cursor: pointer;
        font-size: 2.5rem;
        transition: color 0.3s;
    }
    .close-btn:hover {
        color: #ff4757;
    }
    .container-fluid {
        background-color: #f1f2f6;
        padding: 30px;
    }
    .card {
        border: none;
    }
    .card-header {
        background-color: #ffffff;
        border-bottom: 1px solid #dee2e6;
    }
    .card-body {
        background-color: #ffffff;
    }
    p {
        font-size: 18px;
        line-height: 1.5;
    }
    h4, h5 {
        color: #2f3542;
    }
</style>

<div class="container-fluid px-4">
    <div class="card mt-4 shadow-sm">
        <div class="card-header">
            <h4 class="mb-0">User Manual</h4>
        </div>
        <div class="card-body">
            <h5 class="mt-2">Guideline Videos</h5>
            <div class="row">
                <div class="col-md-12">
                    <div class="small-img-row">
                        <div class="small-img">
                            <img src="user-manual-source/first-order.png" class="small-img-left">
                            <i class="bi bi-play-circle-fill play-btn" onclick="playVideo('user-manual-source/order.mp4')"></i>
                        </div>
                        <p><strong>Creating a new order details for beginner</strong> <br>(Complete Tutorial) - version 24.06.1<br>Fakhrul Studio</p>
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="small-img-row">
                        <div class="small-img">
                            <img src="user-manual-source/existCust.png" class="small-img-left">
                            <i class="bi bi-play-circle-fill play-btn" onclick="playVideo('user-manual-source/existCust.mp4')"></i>
                        </div>
                        <p><strong>Using existing customer data to create order</strong> <br>(Complete Tutorial) - version 24.06.1<br>Fakhrul Studio</p>
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="small-img-row">
                        <div class="small-img">
                            <img src="user-manual-source/update-order.png" class="small-img-left">
                            <i class="bi bi-play-circle-fill play-btn" onclick="playVideo('user-manual-source/update-order.mp4')"></i>
                        </div>
                        <p><strong>Updating sale order easy step tutorial</strong> <br>(Complete Tutorial) - version 24.06.1<br>Fakhrul Studio</p>
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="small-img-row">
                        <div class="small-img">
                            <img src="user-manual-source/expense.png" class="small-img-left">
                            <i class="bi bi-play-circle-fill play-btn" onclick="playVideo('user-manual-source/expense.mp4')"></i>
                        </div>
                        <p><strong>Creating new expense detail for sale order</strong> <br>(Complete Tutorial) - version 24.06.1<br>Fakhrul Studio</p>
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="small-img-row">
                        <div class="small-img">
                            <img src="user-manual-source/filter.png" class="small-img-left">
                            <i class="bi bi-play-circle-fill play-btn" onclick="playVideo('user-manual-source/filter.mp4')"></i>
                        </div>
                        <p><strong>Easy Step using Filter Function PenB System</strong> <br>(Complete Tutorial) - version 24.06.1<br>Fakhrul Studio</p>
                    </div>
                </div>
            </div>
        </div>
        <div class="video-player" id="videoPlayer">
            <video width="100%" controls autoplay id="myVideo">
                <source src="user-manual-source/vid-car1.mp4" type="video/mp4">
            </video>
            <i class="bi bi-x-circle-fill close-btn" onclick="stopVideo()"></i>
        </div>
    </div>
</div>

<script>
    var videoPlayer = document.getElementById("videoPlayer");
    var myVideo = document.getElementById("myVideo");

    function stopVideo(){
        videoPlayer.style.display = "none";
        myVideo.pause();
        myVideo.currentTime = 0;
    }

    function playVideo(file){
        myVideo.src = file;
        videoPlayer.style.display = "flex";
        myVideo.play();
    }
</script>

<?php include('includes/footer.php'); ?>
